/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLDateBuilder;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class CSLDate
implements JsonObject {
    private final int[][] dateParts;
    private final String season;
    private final Boolean circa;
    private final String literal;
    private final String raw;

    public CSLDate() {
        this.dateParts = null;
        this.season = null;
        this.circa = null;
        this.literal = null;
        this.raw = null;
    }

    public CSLDate(int[][] dateParts, String season, Boolean circa, String literal, String raw) {
        this.dateParts = dateParts;
        this.season = season;
        this.circa = circa;
        this.literal = literal;
        this.raw = raw;
    }

    public int[][] getDateParts() {
        return this.dateParts;
    }

    public String getSeason() {
        return this.season;
    }

    public Boolean getCirca() {
        return this.circa;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getRaw() {
        return this.raw;
    }

    @Override
    public Object toJson(JsonBuilder builder) {
        if (this.dateParts != null) {
            builder.add("date-parts", this.dateParts);
        }
        if (this.season != null) {
            builder.add("season", this.season);
        }
        if (this.circa != null) {
            builder.add("circa", this.circa);
        }
        if (this.literal != null) {
            builder.add("literal", this.literal);
        }
        if (this.raw != null) {
            builder.add("raw", this.raw);
        }
        return builder.build();
    }

    public static CSLDate fromJson(Map<String, Object> obj) {
        CSLDateBuilder builder = new CSLDateBuilder();
        Collection v = obj.get("date-parts");
        if (v != null) {
            if (v instanceof Map) {
                v = ((Map)((Object)v)).values();
            } else if (!(v instanceof Collection)) {
                throw new IllegalArgumentException("`date-parts' must be an array");
            }
            Collection cv = v;
            int[][] dateParts = new int[cv.size()][];
            int i = 0;
            for (Object vo : cv) {
                if (vo instanceof Map) {
                    vo = ((Map)vo).values();
                } else if (!(vo instanceof Collection)) {
                    throw new IllegalArgumentException("`date-parts' must be an array of arrays");
                }
                Collection icv = (Collection)vo;
                dateParts[i] = new int[icv.size()];
                int j = 0;
                for (Object ivo : icv) {
                    dateParts[i][j] = CSLDate.toInt(ivo);
                    ++j;
                }
                ++i;
            }
            builder.dateParts(dateParts);
        }
        if ((v = obj.get("season")) != null) {
            String season = v.toString();
            builder.season(season);
        }
        if ((v = obj.get("circa")) != null) {
            Boolean circa = CSLDate.toBool(v);
            builder.circa(circa);
        }
        if ((v = obj.get("literal")) != null) {
            String literal = v.toString();
            builder.literal(literal);
        }
        if ((v = obj.get("raw")) != null) {
            String raw = v.toString();
            builder.raw(raw);
        }
        return builder.build();
    }

    private static boolean isFalsy(Object o) {
        if (o == null) {
            return true;
        }
        if (Boolean.FALSE.equals(o)) {
            return true;
        }
        if ("".equals(o)) {
            return true;
        }
        if (Integer.valueOf(0).equals(o)) {
            return true;
        }
        if (Long.valueOf(0L).equals(o)) {
            return true;
        }
        if (o instanceof Float && (Float.valueOf(0.0f).equals(o) || ((Float)o).isNaN())) {
            return true;
        }
        if (o instanceof Double && (Double.valueOf(0.0).equals(o) || ((Double)o).isNaN())) {
            return true;
        }
        if (Byte.valueOf((byte)0).equals(o)) {
            return true;
        }
        return Short.valueOf((short)0).equals(o);
    }

    private static int toInt(Object o) {
        if (o instanceof CharSequence) {
            return Integer.parseInt(o.toString());
        }
        return ((Number)o).intValue();
    }

    private static boolean toBool(Object o) {
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        return (Boolean)o;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.dateParts);
        result = 31 * result + (this.season == null ? 0 : this.season.hashCode());
        result = 31 * result + (this.circa == null ? 0 : this.circa.hashCode());
        result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
        result = 31 * result + (this.raw == null ? 0 : this.raw.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSLDate)) {
            return false;
        }
        CSLDate other = (CSLDate)obj;
        if (!Arrays.deepEquals((Object[])this.dateParts, (Object[])other.dateParts)) {
            return false;
        }
        if (this.season == null ? other.season != null : !this.season.equals(other.season)) {
            return false;
        }
        if (this.circa == null ? other.circa != null : !this.circa.equals(other.circa)) {
            return false;
        }
        if (this.literal == null ? other.literal != null : !this.literal.equals(other.literal)) {
            return false;
        }
        return !(this.raw == null ? other.raw != null : !this.raw.equals(other.raw));
    }
}

