/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/MessageCollectorAdapter;", "Lorg/jetbrains/kotlin/util/Logger;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "log", "", "message", "", "warning", "strongWarning", "error", "fatal", "", "ir.serialization.common"})
final class MessageCollectorAdapter
implements Logger {
    @NotNull
    private final MessageCollector messageCollector;

    public MessageCollectorAdapter(@NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        this.messageCollector = messageCollector;
    }

    @Override
    public void log(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        this.messageCollector.report(CompilerMessageSeverity.INFO, message2, null);
    }

    @Override
    public void warning(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        this.messageCollector.report(CompilerMessageSeverity.WARNING, message2, null);
    }

    @Override
    public void strongWarning(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        this.messageCollector.report(CompilerMessageSeverity.STRONG_WARNING, message2, null);
    }

    @Override
    public void error(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        this.messageCollector.report(CompilerMessageSeverity.ERROR, message2, null);
    }

    @Override
    @Deprecated(message="Invocation of fatal() may cause severe side effects such as throwing an exception or even terminating the current JVM process (check various implementations of this function for details). The code that uses Logger.fatal() sometimes expects a particular kind of side effect. This is an undesirable design. And it's definitely not a responsibility of Logger to influence the execution flow of the program.", replaceWith=@ReplaceWith(expression="error(message)", imports={}))
    @NotNull
    public Void fatal(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        this.error(message2);
        throw new CompilationErrorException();
    }
}

